<?PHP
// Par : Ahmed ZERZIH
//Reoleweb

//Cette classe permet de gérer la table users
//
// La partie vue est dans le fichier VisiteursHTML.php
namespace Classe;

use mysqlDB;
use views\VisiteursHtml;

class Visiteurs
{
    public array $data = [];

    public int $idVisiteur;
    public $idFournisseur;
    public $civilite;
    public $nom;
    public $prenom;

    private mysqlDB $conn;
    private $id_visiteur;
    private $id_fournisseur;

    //Funciton de construction 
    //cette fonction valide le nombre de paramettre passé en argument et redirige vers le bon constructeur
    //Si aucun parametre c'est un appel de la requete SQL donc initialise les variables. 
    //En PHP 8 plus besoin de mettre les variables dans le constructeur il crée automatiquement des variable privé 
    public function __construct()
    {
        $args = func_get_args();
        $numArgs = func_num_args();

        if ($numArgs > 0) {
            if (method_exists($this, $f = '__construct' . $numArgs)) {
                call_user_func_array([$this, $f], $args);
            }
        } else {
            $this->idVisiteur = 0;
            $this->idFournisseur = 0;
            $this->civilite = $this->civilite;
            $this->nom = $this->nom;
            $this->prenom = $this->prenom;
        }
    }
    //function donstructeur pour les object initialisé avec 7 argument
    //Parametre
    //$nom : Code d'utilisateur
    //$password : mot de passe
    //$lastname : nom de l'utilisateur
    //$prenom : prénom de l'utilisateur
    //$email : courriel de l'utilisatur
    //$comment : Commentaire si besoin
    //$last_time : derniere connextion
    //$last_url : Dernière url visité
    //$last_host : Dernier connexion venait de cette machine
    //$valide_au : si le contrat est fini
    //$filtreCompagnie : numéro de licence de pratique. 
    //Les donnée vienne de la bd
    public function __construct7($civilite, $nom, $prenom)
    {
        $this->civilite = $civilite;
        $this->nom = $nom;
        $this->prenom = $prenom;
        //echo "7";
    }
    //Function constructeur qui créer un object Departement avec la variable de connexion initialisé
    public function __construct1($conn)
    {
        $this->conn = $conn;
        $this->civilite = "";
        $this->nom = "";
        $this->prenom = "";
        $this->id_visiteur = 0;
        $this->id_fournisseur = 0;
    }
    //Function constructeur qui créer un object Departement avec la variable de connexion initialisé et l'id visiteur
    public function __construct2($conn, $idVisiteur)
    {
        $this->idVisiteur = $idVisiteur;
        $this->conn = $conn;
        $sqlVisiteur = "SELECT * FROM visiteurs WHERE id_visiteur=" . $idVisiteur;
        $conn->exec($sqlVisiteur);
        $resultVisiteur = $conn->data;
        foreach ($resultVisiteur as $rowVisiteur) {
            $this->civilite = $rowVisiteur['civilite'];
            $this->nom = $rowVisiteur['nom'];
            $this->prenom = $rowVisiteur['prenom'];
            $this->idVisiteur = $rowVisiteur['id_visiteur'];
            $this->idFournisseur = $rowVisiteur['id_fournisseur'];
        }
    }
    //fonction qui affiche la liste des utilisateurs. 
    //fait appel a la fonction VisiteursHtml::afficheHomeVisiteur pour l'affichage
    public function afficheHomeVisiteur($conn)
    {
        //$conn = $this->conn;
        //récupère les variables passé dans le url en post et en get et ajout un v_ devant. 
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');
        //vide les variables Post et Get
        $_POST[] = "";
        $_GET[] = "";
        $get[] = "";
        $get["page"] = "hv";


        //Affiche la liste des utilisateur avec la fonction VisiteursHtml::afficheHomeVisiteur
        VisiteursHtml::affichePAVisiteur();
    }
    public function getNomVisiteurComplet(): string
    {
        return $this->nom . " " . $this->prenom;
    }
    //fonction qui ajout ou modifie un ustilisateur
    //Le paramtere $type permet d'identifier l'action a faire "ajout/Modifier
    //Fait appel a la classe views\afficheAjoutModifVisiteur.php pour l'affichage
    public function inscriptionVisiteur(string $type)
    {
        $conn = $this->conn;
        include_once("Classe/FunctionClasse.php");
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");

        $get["page"] = "hv";
        $msg = "";
        $companyName = "";
        $champActivite = "";
        $champnom = "";
        $champnomId = 0;
        $champprenom = "";
        $champsecteur = "";
        $champcontactPerson = "";
        $companyId = 0;
        $secteurId = 0;
        $contactId = 0;
        $champobservation = "";

        if (isset($_POST["companyName"])) {
            $companyName = $_POST['companyName'];
            $companyId = $_POST['companyId'];
        } else if (isset($_POST["companyName"]) && $_POST["companyName"] == "") {
            $msg .= "Le champ Nom de votre compagnie est requis.<br />";
            $companyId = 0;
        } else {
            $companyName = "";
            $companyId = 0;
        }

        if (isset($_POST["champActivite"])) {
            $champActivite = $_POST['champActivite'];
        } else if (isset($_POST["champActivite"]) && $_POST["champActivite"] == "") {
            $msg .= "Le champ Activité de votre compagnie est requis.<br />";
        } else {
            $champActivite = "";
        }

        if (isset($_POST["champnom"])) {
            $champnom = $_POST['champnom'];
            $champnomId = $_POST['champnomId'];
        } else if (isset($_POST["champnom"]) && $_POST["champnom"] == "") {
            $msg .= "Le champ Nom est requis.<br />";
            $champnomId = 0;
        } else {
            $champnom = "";
            $champnomId = 0;
        }

        if (isset($_POST["champcivilite"])) {
            $champcivilite = $_POST['champcivilite'];
        } else if (isset($_POST["champcivilite"]) && $_POST["champcivilite"] == "") {
            $msg .= "Le champ Civilité est requis.<br />";
        } else {
            $champcivilite = "";
        }

        if (isset($_POST["champprenom"])) {
            $champprenom = $_POST['champprenom'];
        } else if (isset($_POST["champprenom"]) && $_POST["champprenom"] == "") {
            $msg .= "Le champ Prénom est requis.<br />";
        } else {
            $champprenom = "";
        }

        if (isset($_POST["champsecteur"])) {
            $champsecteur = $_POST['champsecteur'];
            $secteurId = $_POST['secteurId'];
        } else if (isset($_POST["champsecteur"]) && $_POST["champsecteur"] == "") {
            $msg .= "Le champ Secteur à visiter est requis.<br />";
        } else {
            $champsecteur = "";
            $secteurId = 0;
        }

        if (isset($_POST["champcontactPerson"])) {
            $champcontactPerson = $_POST['champcontactPerson'];
            $contactId = $_POST['contactId'];
        } else if (isset($_POST["champcontactPerson"]) && $_POST["champcontactPerson"] == "") {
            $msg .= "Le champ Contact à visiter est requis.<br />";
            $contactId = 0;
        } else {
            $champcontactPerson = "";
            $contactId = 0;
        }
        if (isset($_POST["champDateDebut"])) {
            $champDateDebut = $_POST['champDateDebut'];
        } else if (isset($_POST["champDateDebut"]) && $_POST["champDateDebut"] == "") {
            $msg .= "Le champ Date Début visite est requis.<br />";
        } else {
            $champDateDebut = date("Y-m-d");
        }

        if (isset($_POST["champHeureDebut"])) {
            $champHeureDebut = $_POST['champHeureDebut'];
        } else if (isset($_POST["champHeureDebut"]) && $_POST["champHeureDebut"] == "") {
            $msg .= "Le champ Heure Début visite est requis.<br />";
        } else {
            $champHeureDebut = "08:00";
        }

        if (!$useOnlyFirstDate) {
            //on utilise les deux date , Date début et Date Fin 
            if (isset($_POST["champDatefin"])) {
                $champDatefin = $_POST['champDatefin'];
            } else if (isset($_POST["champDatefin"]) && $_POST["champDatefin"] == "") {
                $msg .= "Le champ Date Fin de la visite est requis.<br />";
            } else {
                $champDatefin = date("Y-m-d");
            }
        } else{
            $champDatefin = date("Y-m-d");
        }

        if (isset($_POST["champHeurefin"])) {
            $champHeurefin = $_POST['champHeurefin'];
        } else if (isset($_POST["champHeurefin"]) && $_POST["champHeurefin"] == "") {
            $msg .= "Le champ Heure Fin de la visite est requis.<br />";
        } else {
            $champHeurefin = "17:00";
        }


        if (isset($_POST["champobservation"])) {
            $champobservation = $_POST['champobservation'];
        } else {
            $champobservation = "";
        }


        if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['confirmation']) && $_POST['confirmation'] == 1) {

            if ($companyId == 0) {
                $SqlInsComp = "SELECT * FROM fournisseur WHERE UPPER(nom_compagnie) = '" . strtoupper(addslashes(trim($companyName))) . "'";
                $conn->exec($SqlInsComp);
                $resultcomp = $conn->data;

                if (empty($resultcomp)) {
                    $SqlInsertComp = "INSERT INTO fournisseur (nom_compagnie, activite) VALUES ('" . strtoupper(addslashes(trim($companyName))) . "', '" . strtoupper(addslashes(trim($champActivite))) . "')";
                    $conn->exec($SqlInsertComp);

                    if ($conn->rows > 0) {
                        $companyId = mysqli_insert_id($conn->link_id);
                    }
                } else {
                    $companyId = $resultcomp[0]['id_fournisseur'];
                }
            }


            if (!empty($champnom) && !empty($champprenom)) {
                $SqlInsComp = "SELECT * FROM visiteurs WHERE UPPER(nom) = '" . strtoupper(addslashes(trim($champnom))) . "' 
                AND UPPER(prenom) = '" . strtoupper(addslashes(trim($champprenom))) . "'";
                $conn->exec($SqlInsComp);
                $resultnom = $conn->data;

                if (empty($resultnom)) {
                    $SqlInsertComp = "INSERT INTO visiteurs (id_fournisseur, civilite, nom, prenom) 
                    VALUES 
                    (" . $companyId . ", '" . strtoupper(addslashes(trim($champcivilite))) . "', '" . strtoupper(addslashes(trim($champnom))) . "', '" . strtoupper(addslashes(trim($champprenom))) . "')";
                    $conn->exec($SqlInsertComp);

                    if ($conn->rows > 0) {
                        $visiteurId = mysqli_insert_id($conn->link_id);
                    }
                } else {
                    $visiteurId = $resultnom[0]['id_visiteur'];
                }
            }

            if ($secteurId == 0) {
                $SqlInssect = "SELECT * FROM secteur_a_visiter WHERE UPPER(nom_secteur) = '" . strtoupper(addslashes(trim($champsecteur))) . "'";
                $conn->exec($SqlInssect);
                $resultsect = $conn->data;

                if (empty($resultsect)) {
                    $SqlInssect = "INSERT INTO secteur_a_visiter (nom_secteur) VALUES ('" . strtoupper(addslashes(trim($champsecteur))) . "')";
                    $conn->exec($SqlInssect);

                    if ($conn->rows > 0) {
                        $secteurId = mysqli_insert_id($conn->link_id);
                    }
                } else {
                    $secteurId = $resultsect[0]['id_secteur'];
                }
            }

            if ($contactId == 0) {
                $SqlInscontact = "SELECT * FROM contact_a_visiter WHERE UPPER(nom_contact) = '" . strtoupper(addslashes(trim($champcontactPerson))) . "'";
                $conn->exec($SqlInscontact);
                $resultcont = $conn->data;

                if (empty($resultcont)) {
                    $SqlInscontact = "INSERT INTO contact_a_visiter (nom_contact) VALUES ('" . strtoupper(addslashes(trim($champcontactPerson))) . "')";
                    $conn->exec($SqlInscontact);

                    if ($conn->rows > 0) {
                        $contactId = mysqli_insert_id($conn->link_id);
                    }
                } else {
                    $contactId = $resultcont[0]['id_contact'];
                }
            }

            $sqlInsert = "
            INSERT INTO `visites_visiteurs` 
            (`id_visite`, `id_visiteur`, `date_debut`, `heure_debut`, `date_fin`, `heure_fin`, `secteur`, `contact`, `observation`) 
            VALUES 
            (NULL, '" . addslashes(trim($visiteurId)) . "', '" . addslashes(trim($champDateDebut)) . "', 
            '" . addslashes(trim($champHeureDebut)) . "', '" . addslashes(trim($champDateFin)) . "', '" . addslashes(trim($champHeurefin)) . "', 
            '" . addslashes(trim($secteurId)) . "', '" . addslashes(trim($contactId)) . "', 
            '" . addslashes(trim($champobservation)) . "');";

            $conn->exec($sqlInsert);
            VisiteursHtml::impressionBadgeVisiteur($conn, $companyName, $champActivite, $champcivilite, $champnom, $champprenom, $champnomId, $champsecteur, $champcontactPerson, $champDateDebut, $champHeureDebut, $champDatefin, $champHeurefin, $companyId, $secteurId, $contactId, $msg);
        } else if ($msg == "" && $_SERVER["REQUEST_METHOD"] === "POST") {
            VisiteursHtml::confirmationDonneesVisiteur($conn, $companyName, $champActivite, $champcivilite, $champnom, $champprenom, $champnomId, $champsecteur, $champcontactPerson, $champDateDebut, $champHeureDebut, $champDatefin, $champHeurefin, $companyId, $secteurId, $contactId, $msg);
        } else {
            $sql = "SELECT id_fournisseur, nom_compagnie FROM fournisseur ORDER BY nom_compagnie ASC";
            $conn->exec($sql);
            //$conn->exec($sql); //, "Classe\\Visiteurs"
            $resultcomp = $conn->data;

            $sql = "SELECT id_secteur, nom_secteur FROM secteur_a_visiter ORDER BY nom_secteur ASC";
            $conn->exec($sql);
            //$conn->exec($sql); //, "Classe\\Visiteurs"
            $resultsecteur = $conn->data;
            VisiteursHtml::inscriptionVisiteur($conn, $resultcomp, $resultsecteur, $companyName, $champActivite, $champcivilite, $champnom, $champprenom, $champnomId, $champsecteur, $champcontactPerson, $champDateDebut, $champHeureDebut, $champDatefin, $champHeurefin, $companyId, $secteurId, $contactId, $msg);
        }
    }

    public function confirmationDonneesVisiteur(string $type)
    {        //redirige vers la liste des utilisateurs
        $this->afficheHomeVisiteur($this->conn);
    }

    //fonction qui vérifie si l'usager est administrateur 
    //Retourne 1 si oui
    //Parametre 
    //$visiteur Objet classe\visiteur
    public function isAdmin(Visiteurs $visiteur)
    {
        $sql = "SELECT COUNT(*) AS N FROM users_roles WHERE id_user=$visiteur->idVisiteur AND id_role=1";
        $this->conn->exec($sql);
        $result = $this->conn->data[0];

        if ($result[0] > 0)
            return 1;
        else
            return 0;
    }
    //fonction qui vérifie si l'usager est un pilote ou administrateur
    //Retourne 1 si oui
    //Parametre 
    //$visiteur Objet classe\visiteur
    function isPilote(Visiteurs $visiteur)
    {
        $sql = "SELECT COUNT(*) AS N FROM users_roles WHERE id_user=$visiteur->idVisiteur AND (id_role=1 OR id_role=2)";
        $this->conn->exec($sql);
        $result = $this->conn->data[0];

        if ($result[0] > 0)
            return 1;
        else
            return 0;
    }
    //fonction qui vérifie si l'usager est un gestionnaire, Administrateur ou pilote
    //Retourne 1 si oui
    //Parametre 
    //$visiteur Objet classe\visiteur
    function isGestion(Visiteurs $visiteur)
    {
        $sql = "SELECT COUNT(*) AS N FROM users_roles WHERE id_user=$visiteur->idVisiteur AND (id_role=1 OR id_role=2 OR id_role=4)";
        $this->conn->exec($sql);
        $result = $this->conn->data[0];

        if ($result[0] > 0)
            return 1;
        else
            return 0;
    }
    //vérifie si l'object visiteur a une date de fin de contrat et la retourne 
    function valideContrat()
    {
        // Vérifier si le contrat est terminé
        $sql = "SELECT valide_au FROM users WHERE id_user=$this->idVisiteur";
        $this->conn->exec($sql);
        return $this->conn->data[0]['valide_au'];
    }
    //Fonction qui récupère les informaiton de l'usager passer en parametre pour cette Object
    //Parametre 
    //Visiteurname : code de l,usager
    //retourne le nombre de rangé trouvé pour cette nom
    public function setVisiteurDep(string $nom): int
    {
        $sql = "SELECT users.*, departements.id_departement as idDep 
        FROM users 
        LEFT JOIN departement_user ON departement_user.id_user = users.id_user 
        LEFT JOIN departements ON departements.id_departement = departement_user.id_departement 
        WHERE LOWER(nom)='$nom' AND valide_au IS NULL Group BY users.id_user";
        $this->conn->exec($sql, "Classe\Visiteurs");
        $nrows = $this->conn->rows;
        if ($nrows > 0) {

            $rowVisiteur = $this->conn->data[0];
            $this->nom = $rowVisiteur['nom'];
        }
        return $this->conn->rows;
    }
    //fonction qui vérifie si le nom et le password est bon
    //parametre 
    //nom : code d,usager de l'utilisateur
    //password ; mot de passe de l'utilisateur
    //Retourne : le nombre de rows trouvé. 
    function valideLogin($nom, $password): int
    {
        $password2 = md5($password);
        $sql2 = "SELECT * FROM users WHERE LOWER(nom)='$nom' AND password='$password2' AND valide_au IS NULL";
        $this->conn->exec($sql2);
        return  $this->conn->rows;
    }
    //fonction qui enregistre la dernière page visite par l'utilisateur. 
    //Parametre
    //LastPage : adresse de la dernière page
    //idVisiteur : l'id de l'usager qui visite la page. 
    function setVisiteurAccesPage($lastPage, $idVisiteur)
    {
        $sql = "UPDATE users SET last_time='c', last_url='$lastPage', last_host='c' WHERE id_user=$idVisiteur";
        $this->conn->exec($sql);
    }
}
