<?php
namespace Classe;

use views\RolesHtml;

class Roles
{
    public $idRole;
    public $roleName;
    public $roleComment;
    public $lastmod;
    private $id_role;
    private $role_comment;
    private $role_name;
    private $conn;
    public $N;
    public $firstname;
    public $lastname;
    //Funciton de construction 
    //cette fonction valide le nombre de paramettre passé en argument et redirige vers le bon constructeur
    //Si aucun parametre c'est un appel de la requete SQL donc initialise les variables. 
    //En PHP 8 plus besoin de mettre les variables dans le constructeur il crée automatiquement des variable privé 
    public function __construct()
    {
        $args = func_get_args();
        $numArgs = func_num_args();

        if ($numArgs > 0) {
            if (method_exists($this, $f = '__construct' . $numArgs)) {
                call_user_func_array([$this, $f], $args);
            }
        } else {
            $this->idRole = $this->id_role;
            $this->roleName = $this->role_name;
            $this->roleComment = $this->role_comment;
        }
    }
    //Function constructeur qui créer un object Departement avec la variable de connexion initialisé    
    public function __construct1($conn)
    {
        $this->conn = $conn;
    }
    //Function constructeur qui créer un object Departement avec la variable de connexion initialisé et l'id Role
    public function __construct2($conn, $idRole)
    {
        $this->conn = $conn;
        $this->idRole = $idRole;
    }

    //Fonction qui fait afficher la liste des roles de la basse de donnée
    //Fait appel a la classe RolesHtml::AfficheRole pour l'affichage
    public function afficheLiteRoles()
    {
        $conn = $this->conn;

        $sql = "SELECT id, nom_role, description, niveau_acces
                FROM roles ORDER BY niveau_acces DESC;";

        $conn->exec($sql);
        $result = $conn->data;
        //fait appel a la méthode AfficheRole pour l'affichage
        RolesHtml::afficheLiteRoles($result);
    }
    //Function qui retourne la liste d'object Roles en ordre de nom de role
    public function getListeRoles()
    {
        $sql2 = "SELECT id, nom_role FROM roles ORDER BY nom_role ASC";
        $this->conn->execObject($sql2, "Classe\\Roles")($sql2);
        $return = $this->conn->data;
    }

    //Retourne l'id des url pour ce role 
    //retourne un tableau
    public function getRolePage($idRole)
    {
        // No longer used in simplified architecture - return empty array
        return array();
    }
    
    function getListeRoleUser($idUser): string
    {
        // Updated query for new database schema
        $sqlRole = "SELECT r.nom_role 
        FROM roles r, users u 
        WHERE r.id = u.role_id AND u.id=" . $idUser."
        ORDER BY r.nom_role ASC";
        $this->conn->exec($sqlRole); 
        $Role = [];

        $resultRole = $this->conn->data;

        foreach ($resultRole as $rowRole) {
            $Role[] = $rowRole['nom_role'];
        }

        // Format the roles properly
        if (count($Role) > 1) {
            $lastRole = array_pop($Role); // Remove last item
            return implode(", ", $Role) . " et " . $lastRole;
        }
        
        return implode(", ", $Role);
    }
}