<?PHP 
class MysqlDB
    // ------------------------------------------------------------------------- //
    {
        public  $link_id;
        public $result;
        public $rows;
        public $data;
        public String $host;
        public String $db;
        public String $user;
        public String $pass;
        public String $verbose;
        public String $echo;
        

        function __construct($host,$db, $user, $pass, $verbose, $echo=true)
        {
            
            $this->host=$host;
            $this->db=$db;
            $this->user=$user;
            $this->pass=$pass;
            $this->verbose=$verbose;
            $this->echo=$echo;
            $this->connect();
        }
        
        
        function __destruct()
        {
            $this->close();
        }
        
        
        function connect()
        {
            $database = $this->host."/".$this->db;
            $this->link_id = mysqli_connect($this->host, $this->user, $this->pass);
            if ($this->link_id)  
            {
                mysqli_select_db($this->link_id, $this->db);
                $this->exec("SET NAMES 'utf8'");
                
                if(( ($this->verbose) ) && $this->echo ){
                    echo "Connected to '$database' with user '$this->user' (MySQL/MariaDB)<br/>";
                }
            }
            else{
                if($this->echo)
                    echo "<span style='color: red;'>Connection to '$database' failed</span><br/>";

            }

                
        }
        
        
        function close()
        {
            mysqli_close($this->link_id);
            if ($this->verbose)
                echo "Closing '$this->db'<br/>";
        }
        
        function execObject($sql,$classe)
        {
            
           
            unset($this->data);
            $this->result = mysqli_query($this->link_id, $sql);
            $this->rows = mysqli_affected_rows($this->link_id);
           
            if( strtoupper(substr($sql,0,6))=="SELECT" && $this->rows>0 )
            {
                while ( $data_row = mysqli_fetch_object($this->result,$classe))
                    $this->data[] = $data_row;
            }
            else
                $this->data = array();
            
           
            if ($this->verbose)
            {
                echo "($this->rows) $sql<br/>";
                if ($this->rows<0)
                {
                    $err = mysqli_error( $this->link_id );
                    echo "<span style='color: red;'>$err</span><br/>";
                }
            }

            return $this->rows;
        }
        function exec($sql)
        // Méthode pour exécuter une requête
        {
           
          
            unset($this->data);
            $this->result = mysqli_query($this->link_id, $sql);
            $this->rows = mysqli_affected_rows($this->link_id);
           
            if( strtoupper(substr($sql,0,6))=="SELECT" && $this->rows>0 )
            {
                while ( $data_row = mysqli_fetch_array($this->result))
                    $this->data[] = $data_row;
            }
            else
                $this->data = array();
            
            
            if ($this->verbose)
            {
                echo "($this->rows) $sql<br/>";
                if ($this->rows<0)
                {
                    $err = mysqli_error( $this->link_id );
                    echo "<span style='color: red;'>$err</span><br/>";
                }
            }

            return $this->rows;
        }
		function execMulti($sql)
        // Méthode pour exécuter une requête multiple
        {
			
            unset($this->data);
            if(mysqli_multi_query($this->link_id, $sql)){
                if($this->echo)
				    echo "<br>result true";
			}else{
                if($this->echo)
				    echo "<br>false";
			}
        }
    }
    ?>
