<?php
namespace Classe;

class AnnonceDetail
{
    private $conn;
    private $annonce;
    private $user;
    private $images;

    public function __construct($conn)
    {
        $this->conn = $conn;
    }

    /**
     * Récupère les détails d'une annonce par son ID
     */
    public function getAnnonceById($id)
    {
        $id = mysqli_real_escape_string($this->conn->link_id, $id);
        
        $sql = "SELECT a.*, 
                       c.nom as categorie_nom,
                       t.nom as transaction_nom,
                       u.username, u.email, u.telephone
                FROM annonces a
                LEFT JOIN categories_biens c ON a.categorie_id = c.id
                LEFT JOIN types_transaction t ON a.type_transaction_id = t.id
                LEFT JOIN users u ON a.user_id = u.id
                WHERE a.id = '$id' AND a.statut = 'publiee' AND a.actif = 1";
        
        $this->conn->exec($sql);
        
        if (!empty($this->conn->data)) {
            $this->annonce = $this->conn->data[0];
            
            // Incrémenter le nombre de vues
            $this->incrementVues($id);
            
            return true;
        }
        
        return false;
    }

    /**
     * Incrémente le nombre de vues de l'annonce
     */
    private function incrementVues($id)
    {
        $sql = "UPDATE annonces SET vues = vues + 1 WHERE id = '$id'";
        $this->conn->exec($sql);
    }

    /**
     * Récupère les images de l'annonce (pour l'instant placeholder)
     */
    public function getImages()
    {
        // Pour l'instant, retourner des images placeholder
        $this->images = [
            'https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=1200&q=80',
            'https://images.unsplash.com/photo-1545324418-cc1a3fa10c00?w=1200&q=80',
            'https://images.unsplash.com/photo-1522708323590-d24dbb6b0267?w=1200&q=80',
            'https://images.unsplash.com/photo-1502672260266-1c1ef2d93688?w=1200&q=80'
        ];
        
        return $this->images;
    }

    /**
     * Récupère les annonces similaires
     */
    public function getAnnoncesSimilaires($limit = 3)
    {
        if (empty($this->annonce)) {
            return [];
        }

        $id = $this->annonce['id'];
        $categorie_id = $this->annonce['categorie_id'];
        $ville = mysqli_real_escape_string($this->conn->link_id, $this->annonce['ville']);
        
        $sql = "SELECT a.*, c.nom as categorie_nom, t.nom as transaction_nom
                FROM annonces a
                LEFT JOIN categories_biens c ON a.categorie_id = c.id
                LEFT JOIN types_transaction t ON a.type_transaction_id = t.id
                WHERE a.id != '$id' 
                AND a.categorie_id = '$categorie_id'
                AND a.statut = 'publiee' 
                AND a.actif = 1
                ORDER BY 
                    CASE WHEN a.ville = '$ville' THEN 0 ELSE 1 END,
                    a.date_publication DESC
                LIMIT $limit";
        
        $this->conn->exec($sql);
        return $this->conn->data ?? [];
    }

    /**
     * Getters
     */
    public function getAnnonce()
    {
        return $this->annonce;
    }

    /**
     * Formate le prix
     */
    public static function formatPrice($price)
    {
        if ($price >= 1000000) {
            return number_format($price / 1000000, 2, '.', ' ') . ' M DA';
        } elseif ($price >= 1000) {
            return number_format($price / 1000, 0, '.', ' ') . ' K DA';
        }
        return number_format($price, 0, '.', ' ') . ' DA';
    }

    /**
     * Décode les caractéristiques JSON
     */
    public function getCaracteristiques()
    {
        if (empty($this->annonce['caracteristiques'])) {
            return [];
        }
        
        $carac = json_decode($this->annonce['caracteristiques'], true);
        return is_array($carac) ? $carac : [];
    }
}
