<?PHP
namespace Classe;

// Par : Ahmed ZERZIH
//Reoleweb

//Cette classe permet de gérer la table users
//
// La partie vue est dans le fichier VisiteursHTML.php

use mysqlDB;
use Views\DashboardHtml;
use views\AnnonceClientHtml;

class AnnonceClient
{
    public array $data = [];

    public int $idVisiteur;
    public $idFournisseur;
    public $civilite;
    public $nom;
    public $prenom;

    private mysqlDB $conn;
    private $id_visiteur;
    private $id_fournisseur;

    //Funciton de construction 
    //cette fonction valide le nombre de paramettre passé en argument et redirige vers le bon constructeur
    //Si aucun parametre c'est un appel de la requete SQL donc initialise les variables. 
    //En PHP 8 plus besoin de mettre les variables dans le constructeur il crée automatiquement des variable privé 
    public function __construct()
    {
        $args = func_get_args();
        $numArgs = func_num_args();

        if ($numArgs > 0) {
            if (method_exists($this, $f = '__construct' . $numArgs)) {
                call_user_func_array([$this, $f], $args);
            }
        } else {
            $this->idVisiteur = $this->id_visiteur;
            $this->idFournisseur = $this->id_fournisseur;
            $this->civilite = $this->civilite;
            $this->nom = $this->nom;
            $this->prenom = $this->prenom;
        }
    }
    //function donstructeur pour les object initialisé avec 7 argument
    //Parametre
    //$nom : Code d'utilisateur
    //$password : mot de passe
    //$lastname : nom de l'utilisateur
    //$prenom : prénom de l'utilisateur
    //$email : courriel de l'utilisatur
    //$comment : Commentaire si besoin
    //$last_time : derniere connextion
    //$last_url : Dernière url visité
    //$last_host : Dernier connexion venait de cette machine
    //$valide_au : si le contrat est fini
    //$filtreCompagnie : numéro de licence de pratique. 
    //Les donnée vienne de la bd
    public function __construct7($civilite, $nom, $prenom)
    {

        $this->civilite = $civilite;
        $this->nom = $nom;
        $this->prenom = $prenom;
        //echo "7";
    }
    //Function constructeur qui créer un object Departement avec la variable de connexion initialisé
    public function __construct1($conn)
    {
        $this->conn = $conn;
        $this->civilite = "";
        $this->nom = "";
        $this->prenom = "";
        $this->id_visiteur = 0;
        $this->id_fournisseur = 0;
    }
    //Function constructeur qui créer un object Departement avec la variable de connexion initialisé et l'id visiteur
    public function __construct2($conn, $idVisiteur)
    {
        $this->idVisiteur = $idVisiteur;
        $this->conn = $conn;
        $sqlVisiteur = "SELECT * FROM visiteurs WHERE id_visiteur=" . $idVisiteur;
        $conn->exec($sqlVisiteur);
        $resultVisiteur = $conn->data;
        foreach ($resultVisiteur as $rowVisiteur) {
            $this->civilite = $rowVisiteur['civilite'];
            $this->nom = $rowVisiteur['nom'];
            $this->prenom = $rowVisiteur['prenom'];
            $this->idVisiteur = $rowVisiteur['id_visiteur'];
            $this->idFournisseur = $rowVisiteur['id_fournisseur'];
        }
    }
    //fonction qui affiche la liste des annonces clients connectés. 
    //fait appel a la fonction AnnonceClientHtml::afficheAnnonceClient pour l'affichage
    public function afficherAnnonceClient()
    {

        $conn = $this->conn;
        //récupère les variables passé dans le url en post et en get et ajout un v_ devant. 
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');
        //vide les variables Post et Get
        $_POST[] = "";
        $_GET[] = "";
        $get[] = "";
        $get["page"] = "vsts";

        // Vérifier le niveau d'accès de l'utilisateur connecté
        $userLevel = 0;
        $currentUserId = 0;
        $showOnlyUserAnnonces = false;
        
        // Récupérer le nom du site depuis les paramètres
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        
        if (isset($_SESSION[$NomSite]['idUser'])) {
            $currentUserId = $_SESSION[$NomSite]['idUser'];
        }
        
        if (isset($_SESSION[$NomSite]['userRoles'])) {
            $roles = $_SESSION[$NomSite]['userRoles'];
            foreach ($roles as $role) {
                if (isset($role['role_level'])) {
                    $userLevel = max($userLevel, $role['role_level']);
                }
            }
        }
        
        // Si l'utilisateur est un visiteur ou particulier (niveau < 40), ne montrer que ses annonces
        if ($userLevel < 40) {
            $showOnlyUserAnnonces = true;
        }

        // Requête pour récupérer les annonces avec informations des utilisateurs
        $whereClause = "WHERE a.actif = 1 AND u.actif = 1";
        if ($showOnlyUserAnnonces && $currentUserId > 0) {
            $whereClause .= " AND a.user_id = $currentUserId";
        }
        
        $sql = "SELECT SQL_CALC_FOUND_ROWS 
                    a.id, a.titre, a.description, a.prix, a.surface, 
                    a.nb_pieces, a.nb_chambres, a.ville, a.adresse,
                    a.statut, a.date_creation, a.date_publication, 
                    a.vues, a.contacts, a.mise_en_avant,
                    u.id as user_id, u.username, u.prenom, u.nom, u.email, u.telephone,
                    CONCAT(u.prenom, ' ', u.nom) AS nom_complet,
                    cb.nom as categorie_nom,
                    tt.nom as type_transaction,
                    r.nom_role
                FROM annonces a
                LEFT JOIN users u ON a.user_id = u.id
                LEFT JOIN categories_biens cb ON a.categorie_id = cb.id
                LEFT JOIN types_transaction tt ON a.type_transaction_id = tt.id
                LEFT JOIN roles r ON u.role_id = r.id
                $whereClause
                ORDER BY a.date_creation DESC";

        $conn->exec($sql);
        $result = $conn->data;

        //Affiche la liste des annonces avec la fonction AnnonceClientHtml::afficheAnnonceClient
        AnnonceClientHtml::afficheAnnonceClient($result, $showOnlyUserAnnonces, $userLevel);
    }
    //fonction qui affiche la liste des utilisateurs. 
    //fait appel a la fonction VisitesVisiteursHtml::afficheVisiteurs pour l'affichage
    public function afficherfournisseurs()
    {

        $conn = $this->conn;
        //récupère les variables passé dans le url en post et en get et ajout un v_ devant. 
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');
        //vide les variables Post et Get
        $_POST[] = "";
        $_GET[] = "";
        $get[] = "";
        $get["page"] = "user";

        //initialisation des variable
        if (!isset($v_filtrePrenom))
            $v_filtrePrenom = "";
        $filtrePrenom = retireTags($v_filtrePrenom);
        $get['filtrePrenom'] = $filtrePrenom;

        if (!isset($v_filtreNom))
            $v_filtreNom = "";
        $filtreNom = retireTags($v_filtreNom);
        $get['filtreNom'] = $filtreNom;

        if (!isset($v_lastTime))
            $v_lastTime = "";
        $lastTime = retireTags($v_lastTime);
        $get['lastTime'] = $lastTime;

        if (!isset($v_lastUrl))
            $v_lastUrl = "";
        $lastUrl = retireTags($v_lastUrl);
        $get['lastUrl'] = $lastUrl;

        if (!isset($v_lasHost))
            $v_lastHost = "";
        $lastHost = retireTags($v_lastHost);
        $get['lastHost'] = $lastHost;

        if (!isset($v_filtreCompagnie))
            $v_filtreCompagnie = "";
        $filtreCompagnie = retireTags($v_filtreCompagnie);
        $get['filtreCompagnie'] = $filtreCompagnie;

        if (!isset($v_firstname))
            $v_firstname = "";
        $firstname = retireTags($v_firstname);
        $get['firstname'] = $firstname;

        if (!isset($v_lastname))
            $v_lastname = "";
        $lastname = retireTags($v_lastname);
        $get['lastname'] = $lastname;
        // Filtre sur le statut utilisateur
        // 1 = utilisateurs actifs
        // 2 = utilisateurs inactifs
        // 3 = toutes les utilisateurs
        $userStatus = "";
        $get['userStatus'] = $userStatus;
        if (isset($v_userStatus))
            $userStatus = $v_userStatus;
        else
            $userStatus = 1;


        if (!isset($v_status))
            $v_status = "";

        if ($get['userStatus'] != $v_status && $v_status != "") {
            $get['userStatus'] = $v_status;
            $userStatus = $v_status;
        } else {
            $get['userStatus'] = $userStatus;
        }

        // Paramètres de tri pour l'affichage
        if (isset($v_sortBy)) {
            $sortBy = $v_sortBy;
            $get['sortBy'] = $v_sortBy;
        } else {
            $get['sortBy'] = "id_visite";
            $sortBy = "id_visite";
        }

        if (isset($v_sortDir)) {
            $sortDir = $v_sortDir;
            $get['sortDir'] = $v_sortDir;
        } else {
            $get['sortDir'] = "DESC";
            $sortDir = "DESC";
        }

        if (empty($v_offset))
            $v_offset = 0;
        $offset = $v_offset;
        $get['offset'] = $v_offset;

        if (empty($v_rowCount))
            $v_rowCount = 25;
        $get['rowCount'] = $v_rowCount;
        $rowCount = $get['rowCount'];

        $sql = "SELECT count(vv.id_visite) CounVisite, count(vv.id_visiteur) CounVisiteur, f.id_fournisseur, f.nom_compagnie, f.activite, f.email, f.tel, f.banni, f.deleted, f.observation 
        FROM fournisseur f 
        LEFT JOIN visiteurs v on f.id_fournisseur = v.id_fournisseur
        LEFT JOIN visites_visiteurs vv on v.id_visiteur = vv.id_visiteur
        GROUP BY f.id_fournisseur
        ORDER BY f.nom_compagnie ASC";

        $conn->exec("SET CHARACTER SET utf8mb4");
        $conn->exec($sql);
        //$conn->execObject($sql, "Classe\\VisitesVisiteurs"); //
        $result = $conn->data;
        //trouve le nombre de visiteurs
        $sql2 = "SELECT FOUND_ROWS() AS N";
        $conn->exec($sql2);
        $N = $conn->data[0]['N'];
        // creer l'object departement
        $depClass = new Departement($conn);

        //Affiche la liste des utilisateur avec la fonction AnnonceClientHtml::afficherFournisseurs
        AnnonceClientHtml::afficherFournisseurs($userStatus, $result, $offset, $rowCount, $N, $sortBy, $sortDir, $filtrePrenom, $lastTime, $lastUrl, $lastHost, $filtreCompagnie, $firstname, $lastname, $filtreNom, $get, $depClass, $sql);
    }
    //fonction qui affiche la liste des utilisateurs. 
    //fait appel a la fonction VisitesVisiteursHtml::afficheVisiteurs pour l'affichage
    public function afficherVisiteurs()
    {

        $conn = $this->conn;
        //récupère les variables passé dans le url en post et en get et ajout un v_ devant. 
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');
        //vide les variables Post et Get
        $_POST[] = "";
        $_GET[] = "";
        $get[] = "";
        $get["page"] = "user";

        //initialisation des variable
        if (!isset($v_filtrePrenom))
            $v_filtrePrenom = "";
        $filtrePrenom = retireTags($v_filtrePrenom);
        $get['filtrePrenom'] = $filtrePrenom;

        if (!isset($v_filtreNom))
            $v_filtreNom = "";
        $filtreNom = retireTags($v_filtreNom);
        $get['filtreNom'] = $filtreNom;

        if (!isset($v_lastTime))
            $v_lastTime = "";
        $lastTime = retireTags($v_lastTime);
        $get['lastTime'] = $lastTime;

        if (!isset($v_lastUrl))
            $v_lastUrl = "";
        $lastUrl = retireTags($v_lastUrl);
        $get['lastUrl'] = $lastUrl;

        if (!isset($v_lasHost))
            $v_lastHost = "";
        $lastHost = retireTags($v_lastHost);
        $get['lastHost'] = $lastHost;

        if (!isset($v_filtreCompagnie))
            $v_filtreCompagnie = "";
        $filtreCompagnie = retireTags($v_filtreCompagnie);
        $get['filtreCompagnie'] = $filtreCompagnie;

        if (!isset($v_firstname))
            $v_firstname = "";
        $firstname = retireTags($v_firstname);
        $get['firstname'] = $firstname;

        if (!isset($v_lastname))
            $v_lastname = "";
        $lastname = retireTags($v_lastname);
        $get['lastname'] = $lastname;
        // Filtre sur le statut utilisateur
        // 1 = utilisateurs actifs
        // 2 = utilisateurs inactifs
        // 3 = toutes les utilisateurs
        $userStatus = "";
        $get['userStatus'] = $userStatus;
        if (isset($v_userStatus))
            $userStatus = $v_userStatus;
        else
            $userStatus = 1;


        if (!isset($v_status))
            $v_status = "";

        if ($get['userStatus'] != $v_status && $v_status != "") {
            $get['userStatus'] = $v_status;
            $userStatus = $v_status;
        } else {
            $get['userStatus'] = $userStatus;
        }

        // Paramètres de tri pour l'affichage
        if (isset($v_sortBy)) {
            $sortBy = $v_sortBy;
            $get['sortBy'] = $v_sortBy;
        } else {
            $get['sortBy'] = "id_visite";
            $sortBy = "id_visite";
        }

        if (isset($v_sortDir)) {
            $sortDir = $v_sortDir;
            $get['sortDir'] = $v_sortDir;
        } else {
            $get['sortDir'] = "DESC";
            $sortDir = "DESC";
        }

        if (empty($v_offset))
            $v_offset = 0;
        $offset = $v_offset;
        $get['offset'] = $v_offset;

        if (empty($v_rowCount))
            $v_rowCount = 25;
        $get['rowCount'] = $v_rowCount;
        $rowCount = $get['rowCount'];

        $sqlListvisiteur = "SELECT count(vv.id_visiteur) CounVisite, v.id_visiteur, v.id_fournisseur, v.civilite, v.nom, v.prenom, v.email, v.tel, v.banni, v.deleted, v.observation, CONCAT(v.civilite, ' ' ,v.nom, ' ',v.prenom) AS NomComplet, 
        f.nom_compagnie
        FROM visiteurs v
        LEFT JOIN fournisseur f ON v.id_fournisseur = f.id_fournisseur
        LEFT JOIN visites_visiteurs vv ON v.id_visiteur = vv.id_visiteur
        GROUP BY v.id_visiteur
        ORDER BY v.id_visiteur DESC;";

        $conn->exec($sqlListvisiteur);

        $resultlistevisiteur = $conn->data;

        //Affiche la liste des visiteurs avec la fonction AnnonceClientHtml::afficheVisiteurs
        AnnonceClientHtml::afficheVisiteurs($resultlistevisiteur, $sqlListvisiteur);
    }

    public function afficherDashBoard($NomSiteCap)
    {
        $conn = $this->conn;
        include("Parametre/" . getPath(1) . "/" . getPath(1) . ".php");
        //récupère les variables passé dans le url en post et en get et ajout un v_ devant. 
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');
        //vide les variables Post et Get
        $_POST[] = "";
        $_GET[] = "";
        $get[] = "";
        $get["page"] = "user";

        // Récupérer les informations de l'utilisateur connecté
        global $NomSite;
        $userLevel = 0;
        $userId = null;
        $userRole = 'Visiteur';
        
        if (isset($_SESSION[$NomSite]['userRoles']) && !empty($_SESSION[$NomSite]['userRoles'])) {
            $userRoles = $_SESSION[$NomSite]['userRoles'];
            foreach ($userRoles as $role) {
                if (isset($role['role_level']) && $role['role_level'] > $userLevel) {
                    $userLevel = $role['role_level'];
                    $userRole = $role['role_name'] ?? 'Utilisateur';
                }
            }
        }
        
        if (isset($_SESSION[$NomSite]['idUser'])) {
            $userId = $_SESSION[$NomSite]['idUser'];
        }

        // Statistiques personnalisées selon le niveau d'utilisateur
        if ($userLevel >= 80) {
            // Dashboard Administrateur - Vue complète
            $this->afficherDashboardAdmin($NomSiteCap, $conn);
        } elseif ($userLevel >= 40) {
            // Dashboard Agent - Vue intermédiaire
            $this->afficherDashboardAgent($NomSiteCap, $conn, $userId);
        } else {
            // Dashboard Visiteur - Vue limitée
            $this->afficherDashboardVisiteur($NomSiteCap, $conn, $userId);
        }
    }

    /**
     * Dashboard pour les administrateurs - Vue complète du système
     */
    private function afficherDashboardAdmin($NomSiteCap, $conn)
    {
        // Statistiques globales avancées
        $stats = $this->getAdminStatistics($conn);
        
        DashboardHtml::AfficherHtmlDashboard($NomSiteCap, $stats['annonces'], $stats['users'], $stats['contacts'], $stats['annonces_today'], $stats['recent_annonces'], $stats['recent_contacts'], $stats['monthly'], $stats['yearly']['years'], $stats['yearly']['annonces'], 'admin', $stats);
    }

    /**
     * Dashboard pour les agents - Vue intermédiaire
     */
    private function afficherDashboardAgent($NomSiteCap, $conn, $userId)
    {
        // Détecter le type d'agent (Premium vs Particulier)
        global $NomSite;
        $userLevel = 40; // Par défaut
        if (isset($_SESSION[$NomSite]['userRoles'])) {
            foreach ($_SESSION[$NomSite]['userRoles'] as $role) {
                if (isset($role['role_level']) && $role['role_level'] > $userLevel) {
                    $userLevel = $role['role_level'];
                }
            }
        }

        if ($userLevel >= 60) {
            // Agent Premium
            $stats = $this->getAgentPremiumStatistics($conn, $userId);
            DashboardHtml::AfficherHtmlDashboard($NomSiteCap, $stats['annonces'], 0, $stats['contacts'], $stats['annonces_today'], $stats['recent_annonces'], $stats['recent_contacts'], null, null, null, 'agent_premium', $stats);
        } else {
            // Agent Particulier
            $stats = $this->getAgentParticulierStatistics($conn, $userId);
            DashboardHtml::AfficherHtmlDashboard($NomSiteCap, $stats['annonces'], 0, $stats['contacts'], $stats['annonces_today'], $stats['recent_annonces'], $stats['recent_contacts'], null, null, null, 'agent_particulier', $stats);
        }
    }

    /**
     * Dashboard pour les visiteurs - Vue très limitée
     */
    private function afficherDashboardVisiteur($NomSiteCap, $conn, $userId)
    {
        $stats = $this->getVisiteurStatistics($conn, $userId);
        DashboardHtml::AfficherHtmlDashboard($NomSiteCap, $stats['annonces'], 0, $stats['contacts'], 0, $stats['recent_annonces'], null, null, null, null, 'visiteur', $stats);
    }

    /**
     * Statistiques mensuelles pour graphiques
     */
    private function getMonthlyStats($conn)
    {
        $sales = array_fill(0, 12, 0);
        $SqlQuery = "SELECT MONTH(date_creation) AS month, COUNT(*) AS total
        FROM annonces
        WHERE YEAR(date_creation) = 2025
        GROUP BY MONTH(date_creation)
        ORDER BY MONTH(date_creation)";

        $conn->exec($SqlQuery);
        $results = $conn->data;

        foreach ($results as $row) {
            $monthIndex = (int)$row['month'] - 1;
            $sales[$monthIndex] = (int)$row['total'];
        }
        return $sales;
    }

    /**
     * Statistiques annuelles pour graphiques
     */
    private function getYearlyStats($conn)
    {
        $SqlQuery = "SELECT YEAR(date_creation) AS year, COUNT(*) AS total_annonces
        FROM annonces
        GROUP BY YEAR(date_creation)
        ORDER BY YEAR(date_creation) ASC";

        $conn->exec($SqlQuery);
        $results = $conn->data;
        $years = [];
        $annonces = [];
        
        foreach ($results as $row) {
            $years[] = $row['year'];
            $annonces[] = (int)$row['total_annonces'];
        }

        return ['years' => $years, 'annonces' => $annonces];
    }

    /**
     * Statistiques avancées pour administrateurs
     */
    private function getAdminStatistics($conn)
    {
        $stats = [];

        // Annonces par statut
        $conn->exec("SELECT statut, COUNT(*) as count FROM annonces GROUP BY statut");
        $stats['annonces_by_status'] = $conn->data;

        // Total annonces
        $conn->exec("SELECT COUNT(*) as total FROM annonces");
        $stats['annonces'] = $conn->data[0]['total'];

        // Utilisateurs par type de rôle
        $conn->exec("SELECT r.nom_role, COUNT(u.id) as count 
                     FROM users u 
                     LEFT JOIN roles r ON u.role_id = r.id 
                     WHERE u.actif = 1 
                     GROUP BY r.nom_role");
        $stats['users_by_role'] = $conn->data;

        // Total utilisateurs actifs
        $conn->exec("SELECT COUNT(*) as total FROM users WHERE actif = 1");
        $stats['users'] = $conn->data[0]['total'];

        // Contacts total
        $conn->exec("SELECT COUNT(*) as total FROM contacts");
        $stats['contacts'] = $conn->data[0]['total'];

        // Annonces aujourd'hui
        $conn->exec("SELECT COUNT(*) as total FROM annonces WHERE DATE(date_creation) = CURDATE()");
        $stats['annonces_today'] = $conn->data[0]['total'];

        // Revenus mensuels (simulation)
        $conn->exec("SELECT MONTH(date_creation) as month, COUNT(*) * 50 as revenue 
                     FROM annonces 
                     WHERE YEAR(date_creation) = YEAR(CURDATE()) 
                     GROUP BY MONTH(date_creation)");
        $stats['monthly_revenue'] = $conn->data;

        // Top villes
        $conn->exec("SELECT ville, COUNT(*) as count 
                     FROM annonces 
                     GROUP BY ville 
                     ORDER BY count DESC 
                     LIMIT 5");
        $stats['top_cities'] = $conn->data;

        // Dernières annonces
        $conn->exec("SELECT a.id, a.titre, a.prix, a.surface, a.ville, a.statut, a.date_creation,
                     u.nom, u.prenom, r.nom_role
                     FROM annonces a
                     LEFT JOIN users u ON a.user_id = u.id
                     LEFT JOIN roles r ON u.role_id = r.id
                     WHERE a.actif = 1
                     ORDER BY a.date_creation DESC
                     LIMIT 10");
        $stats['recent_annonces'] = $conn->data;

        // Derniers contacts
        $conn->exec("SELECT c.id, c.nom, c.email, c.telephone, c.message, c.date_envoi as date_contact,
                     a.titre as annonce_titre, a.prix
                     FROM contacts c
                     LEFT JOIN annonces a ON c.annonce_id = a.id
                     ORDER BY c.date_envoi DESC
                     LIMIT 10");
        $stats['recent_contacts'] = $conn->data;

        // Statistiques mensuelles et annuelles
        $stats['monthly'] = $this->getMonthlyStats($conn);
        $stats['yearly'] = $this->getYearlyStats($conn);

        return $stats;
    }

    /**
     * Statistiques pour agents premium
     */
    private function getAgentPremiumStatistics($conn, $userId)
    {
        $stats = [];

        // Mes annonces par statut
        $conn->exec("SELECT statut, COUNT(*) as count 
                     FROM annonces 
                     WHERE user_id = $userId 
                     GROUP BY statut");
        $stats['my_annonces_by_status'] = $conn->data;

        // Total mes annonces
        $conn->exec("SELECT COUNT(*) as total FROM annonces WHERE user_id = $userId");
        $stats['annonces'] = $conn->data[0]['total'];

        // Mes contacts
        $conn->exec("SELECT COUNT(*) as total 
                     FROM contacts c 
                     INNER JOIN annonces a ON c.annonce_id = a.id 
                     WHERE a.user_id = $userId");
        $stats['contacts'] = $conn->data[0]['total'];

        // Mes annonces aujourd'hui
        $conn->exec("SELECT COUNT(*) as total 
                     FROM annonces 
                     WHERE user_id = $userId AND DATE(date_creation) = CURDATE()");
        $stats['annonces_today'] = $conn->data[0]['total'];

        // Mon chiffre d'affaires estimé
        $conn->exec("SELECT SUM(prix * 0.03) as ca_estime 
                     FROM annonces 
                     WHERE user_id = $userId AND statut = 'vendu'");
        $stats['my_revenue'] = $conn->data[0]['ca_estime'] ?? 0;

        // Performance vs moyenne
        $conn->exec("SELECT 
                     (SELECT COUNT(*) FROM annonces WHERE user_id = $userId) as my_count,
                     (SELECT COUNT(*) / (SELECT COUNT(DISTINCT user_id) FROM annonces) FROM annonces) as avg_count");
        $result = $conn->data[0];
        $stats['performance_vs_avg'] = $result['my_count'] / ($result['avg_count'] ?: 1);

        // Mes dernières annonces
        $conn->exec("SELECT a.id, a.titre, a.prix, a.surface, a.ville, a.statut, a.date_creation
                     FROM annonces a
                     WHERE a.user_id = $userId
                     ORDER BY a.date_creation DESC
                     LIMIT 10");
        $stats['recent_annonces'] = $conn->data;

        // Mes derniers contacts
        $conn->exec("SELECT c.id, c.nom, c.email, c.telephone, c.message, c.date_contact,
                     a.titre as annonce_titre, a.prix
                     FROM contacts c
                     INNER JOIN annonces a ON c.annonce_id = a.id
                     WHERE a.user_id = $userId
                     ORDER BY c.date_contact DESC
                     LIMIT 10");
        $stats['recent_contacts'] = $conn->data;

        return $stats;
    }

    /**
     * Statistiques pour agents particuliers
     */
    private function getAgentParticulierStatistics($conn, $userId)
    {
        $stats = [];

        // Mes annonces
        $conn->exec("SELECT COUNT(*) as total FROM annonces WHERE user_id = $userId");
        $stats['annonces'] = $conn->data[0]['total'];

        // Mes contacts
        $conn->exec("SELECT COUNT(*) as total 
                     FROM contacts c 
                     INNER JOIN annonces a ON c.annonce_id = a.id 
                     WHERE a.user_id = $userId");
        $stats['contacts'] = $conn->data[0]['total'];

        // Aujourd'hui
        $conn->exec("SELECT COUNT(*) as total 
                     FROM annonces 
                     WHERE user_id = $userId AND DATE(date_creation) = CURDATE()");
        $stats['annonces_today'] = $conn->data[0]['total'];

        // Durée moyenne de mes annonces
        $conn->exec("SELECT AVG(DATEDIFF(CURDATE(), date_creation)) as avg_duration 
                     FROM annonces 
                     WHERE user_id = $userId");
        $stats['avg_duration'] = round($conn->data[0]['avg_duration'] ?? 0);

        // Prix moyen de mes biens
        $conn->exec("SELECT AVG(prix) as avg_price 
                     FROM annonces 
                     WHERE user_id = $userId");
        $stats['avg_price'] = $conn->data[0]['avg_price'] ?? 0;

        // Vues totales (simulation)
        $stats['total_views'] = $stats['annonces'] * rand(50, 200);

        // Mes dernières annonces
        $conn->exec("SELECT a.id, a.titre, a.prix, a.surface, a.ville, a.statut, a.date_creation
                     FROM annonces a
                     WHERE a.user_id = $userId
                     ORDER BY a.date_creation DESC
                     LIMIT 5");
        $stats['recent_annonces'] = $conn->data;

        // Mes derniers contacts
        $conn->exec("SELECT c.id, c.nom, c.email, c.telephone, c.message, c.date_contact,
                     a.titre as annonce_titre, a.prix
                     FROM contacts c
                     INNER JOIN annonces a ON c.annonce_id = a.id
                     WHERE a.user_id = $userId
                     ORDER BY c.date_contact DESC
                     LIMIT 5");
        $stats['recent_contacts'] = $conn->data;

        return $stats;
    }

    /**
     * Statistiques pour visiteurs
     */
    private function getVisiteurStatistics($conn, $userId)
    {
        $stats = [];

        if ($userId) {
            // Mes annonces
            $conn->exec("SELECT COUNT(*) as total FROM annonces WHERE user_id = $userId");
            $stats['annonces'] = $conn->data[0]['total'];

            // Mes contacts
            $conn->exec("SELECT COUNT(*) as total 
                         FROM contacts c 
                         INNER JOIN annonces a ON c.annonce_id = a.id 
                         WHERE a.user_id = $userId");
            $stats['contacts'] = $conn->data[0]['total'];

            // Intérêt généré (simulation)
            $stats['total_views'] = $stats['annonces'] * rand(10, 50);
            $stats['avg_views_per_annonce'] = $stats['annonces'] > 0 ? round($stats['total_views'] / $stats['annonces']) : 0;

            // Mes annonces
            $conn->exec("SELECT a.id, a.titre, a.prix, a.surface, a.ville, a.statut, a.date_creation
                         FROM annonces a
                         WHERE a.user_id = $userId
                         ORDER BY a.date_creation DESC
                         LIMIT 5");
            $stats['recent_annonces'] = $conn->data;
        } else {
            $stats['annonces'] = 0;
            $stats['contacts'] = 0;
            $stats['total_views'] = 0;
            $stats['avg_views_per_annonce'] = 0;
            $stats['recent_annonces'] = null;
        }

        return $stats;
    }

    public function getNomVisiteurComplet(): string
    {
        return $this->nom . " " . $this->prenom;
    }

    public function ajoutModifVisiteurCommit(string $type)
    {
        $conn = $this->conn;
        //import_request_variables('gp', 'v_');
        extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'v');
        $tabPost = $_POST;
        $_POST[] = "";
        $defaultPassword = "changepassword";
        $myVisiteurId = $_SESSION['gestionvisiteur']['idVisiteur'];
        $idDepartement = $_SESSION['gestionvisiteur']['idDepartement'];
        if (!isset($v_idVisiteur))
            $v_idVisiteur = "";
        $idVisiteur = $v_idVisiteur;
        if (!isset($v_nom))
            $v_nom = "";
        $nom = retireTags($v_nom);

        if (!isset($v_lastname))
            $v_lastname = "";
        $lastname = retireTags(mysqli_real_escape_string($conn->link_id, $v_lastname));
        if (!isset($v_prenom))
            $v_prenom = "";
        $prenom = retireTags(mysqli_real_escape_string($conn->link_id, $v_prenom));
        if (!isset($v_email))
            $v_email = "";
        $email = retireTags($v_email);
        if (!isset($v_comment))
            $v_comment = "";
        $comment = retireTags(mysqli_real_escape_string($conn->link_id, $v_comment));
        if (!isset($v_finContrat))
            $v_finContrat = "";
        $finContrat = $v_finContrat;
        if (!isset($v_resetPassword))
            $v_resetPassword = "";
        $resetPassword = $v_resetPassword;
        if (!isset($v_userRoles))
            $v_userRoles = array();
        $userRoles = $v_userRoles;
        if (!isset($v_filtreCompagnie))
            $v_filtreCompagnie = "";
        $filtreCompagnie = retireTags($v_filtreCompagnie);
        if (!isset($v_idDepartement))
            $v_idDepartement = array();
        $idDepartement = $v_idDepartement;

        // On vérifie que nom n'existe pas déjà
        if (empty($idVisiteur))
            $sql = "SELECT nom FROM Visiteurs WHERE nom='$nom'";  // ajouter
        else
            $sql = "SELECT nom FROM Visiteurs WHERE nom='$nom' AND id_user<>$idVisiteur"; // modifier
        $conn->exec($sql);
        $nrows = $conn->rows;

        if ($nrows > 0) {
            echo "<script type='text/javascript'> alert('Erreur : l\'utilisateur \"$nom\" existe déjà!'); </script>";
        } else {
            //ajout (si nécessaire)
            $sql1 = "";
            $sql2 = "";
            if ($type == "ajout") {
                $sql1 = "INSERT INTO Visiteurs (nom, password) VALUES ('$nom', '" . md5($defaultPassword) . "'); ";
                $conn->exec($sql1);
                $idVisiteur = mysqli_insert_id($conn->link_id);
                $nrows = $conn->rows;
            } else
                $nrows = 0;

            if ($nrows >= 0) {
                //modification
                if (empty($finContrat))
                    $finContrat = 'NULL';
                else
                    $finContrat = "'" . $finContrat . "'";

                if (empty($filtreCompagnie))
                    $filtreCompagnie = 'NULL';
                else
                    $filtreCompagnie = "'" . $filtreCompagnie . "'";

                if ($resetPassword == 1)
                    $sql2 = "UPDATE users SET nom='$nom', password='" . md5($defaultPassword) . "', lastname='$lastname', prenom='$prenom', email='$email', comment='$comment', valide_au=$finContrat, filtreCompagnie=$filtreCompagnie WHERE id_user=$idVisiteur";
                else
                    $sql2 = "UPDATE users SET nom='$nom', lastname='$lastname', prenom='$prenom', email='$email', comment='$comment', valide_au=$finContrat, filtreCompagnie=$filtreCompagnie WHERE id_user=$idVisiteur";
                $conn->exec($sql2);
            }

            WriteWhoDidWhat::enregistre($myVisiteurId, $sql1 . $sql2, "usagersAjoutModifCommit", $conn);
            if (!empty($sql3))
                WriteWhoDidWhat::enregistre($myVisiteurId, $sql3, "usagersAjoutModifCommit", $conn);
        }

        // Rôles de l'utilisateur
        // On efface tous les enregistrements de "users_roles" correspondant à l'utilsateur ajouté/modifié
        $sql = "DELETE FROM users_roles WHERE id_user=$idVisiteur";
        $conn->exec($sql);
        WriteWhoDidWhat::enregistre($myVisiteurId, $sql, "usagersAjoutModifCommit.php", $conn);

        // On ajoute ensuite les pages sélectionnées
        if (!empty($userRoles)) {
            $sql = "INSERT INTO users_roles (id_user, id_role) VALUES";
            $str = "";
            foreach ($userRoles as $row) {
                $str = $str . " ($idVisiteur, $row),";
            }
            $str = substr($str, 0, -1);
            $sql = $sql . $str;
            $conn->exec($sql);
            WriteWhoDidWhat::enregistre($myVisiteurId, $sql, "usagersAjoutModifCommit.php", $conn);
        }
        //Departement
        $sqlDepartement = "DELETE FROM departement_user WHERE id_user = $idVisiteur";
        $conn->exec($sqlDepartement);

        if ($idDepartement != '') {
            foreach ($idDepartement as $dep) {
                $sqlDepartement = "INSERT INTO departement_user (id_user,id_departement) VALUES($idVisiteur,$dep)";
                $conn->exec($sqlDepartement);
            }
        }

        if ($sqlDepartement != '') {

            WriteWhoDidWhat::enregistre($myVisiteurId, $sqlDepartement, "usagersAjoutModifCommit", $conn);
        }

        //redirige vers la liste des utilisateurs
        $this->afficherAnnonceClient();
    }

    //fonction qui vérifie si l'usager est administrateur 
    //Retourne 1 si oui
    //Parametre 
    //$visiteur Objet classe\visiteur
    public function isAdmin(Visiteurs $visiteur)
    {
        $sql = "SELECT COUNT(*) AS N FROM users_roles WHERE id_user=$visiteur->idVisiteur AND id_role=1";
        $this->conn->exec($sql);
        $result = $this->conn->data[0];

        if ($result[0] > 0)
            return 1;
        else
            return 0;
    }
    //fonction qui vérifie si l'usager est un pilote ou administrateur
    //Retourne 1 si oui
    //Parametre 
    //$visiteur Objet classe\visiteur
    function isPilote(Visiteurs $visiteur)
    {
        $sql = "SELECT COUNT(*) AS N FROM users_roles WHERE id_user=$visiteur->idVisiteur AND (id_role=1 OR id_role=2)";
        $this->conn->exec($sql);
        $result = $this->conn->data[0];

        if ($result[0] > 0)
            return 1;
        else
            return 0;
    }
    //fonction qui vérifie si l'usager est un gestionnaire, Administrateur ou pilote
    //Retourne 1 si oui
    //Parametre 
    //$visiteur Objet classe\visiteur
    function isGestion(Visiteurs $visiteur)
    {
        $sql = "SELECT COUNT(*) AS N FROM users_roles WHERE id_user=$visiteur->idVisiteur AND (id_role=1 OR id_role=2 OR id_role=4)";
        $this->conn->exec($sql);
        $result = $this->conn->data[0];

        if ($result[0] > 0)
            return 1;
        else
            return 0;
    }
    //vérifie si l'object visiteur a une date de fin de contrat et la retourne 
    function valideContrat()
    {
        // Vérifier si le contrat est terminé
        $sql = "SELECT valide_au FROM users WHERE id_user=$this->idVisiteur";
        $this->conn->exec($sql);
        return $this->conn->data[0]['valide_au'];
    }
    //Fonction qui récupère les informaiton de l'usager passer en parametre pour cette Object
    //Parametre 
    //Visiteurname : code de l,usager
    //retourne le nombre de rangé trouvé pour cette nom
    public function setVisiteurDep(string $nom): int
    {
        $sql = "SELECT users.*, departements.id_departement as idDep 
        FROM users 
        LEFT JOIN departement_user ON departement_user.id_user = users.id_user 
        LEFT JOIN departements ON departements.id_departement = departement_user.id_departement 
        WHERE LOWER(nom)='$nom' AND valide_au IS NULL Group BY users.id_user";
        $this->conn->exec($sql);
        $nrows = $this->conn->rows;
        if ($nrows > 0) {

            $rowVisiteur = $this->conn->data[0];
            $this->nom = $rowVisiteur['nom'];
        }
        return $this->conn->rows;
    }
    //fonction qui vérifie si le nom et le password est bon
    //parametre 
    //nom : code d,usager de l'utilisateur
    //password ; mot de passe de l'utilisateur
    //Retourne : le nombre de rows trouvé. 
    function valideLogin($nom, $password): int
    {
        $password2 = md5($password);
        $sql2 = "SELECT * FROM users WHERE LOWER(nom)='$nom' AND password='$password2' AND valide_au IS NULL";
        $this->conn->exec($sql2);
        return  $this->conn->rows;
    }
    //fonction qui enregistre la dernière page visite par l'utilisateur. 
    //Parametre
    //LastPage : adresse de la dernière page
    //idVisiteur : l'id de l'usager qui visite la page. 
    function setVisiteurAccesPage($lastPage, $idVisiteur)
    {
        $sql = "UPDATE users SET last_time='c', last_url='$lastPage', last_host='c' WHERE id_user=$idVisiteur";
        $this->conn->exec($sql);
    }
}
